# ---------------------------------------------------------------------------------------------------------------------
# PARAMETRY WYMAGANE
# Konieczne jest podanie wartości dla każdego z tych parametrów.
# ---------------------------------------------------------------------------------------------------------------------

variable "mysql_config" {
  description = "Konfiguracja bazy danych MySQL"

  type = object({
    address = string
    port    = number
  })

  default = {
    address = "mock-mysql-address"
    port    = 12345
  }
}

# ---------------------------------------------------------------------------------------------------------------------
# PARAMETRY OPCJONALNE
# Te parametry mają rozsądne wartości domyślne.
# ---------------------------------------------------------------------------------------------------------------------

variable "server_text" {
  description = "Ciąg tekstowy zwracany przez serwer"
  default     = "Witaj, świecie"
  type        = string
}

variable "environment" {
  description = "Nazwa środowiska, w którym będzie przeprowadzone wdrożenie"
  type        = string
  default     = "example"
}
